// Copyright 2025 Greyscalegorilla, Inc. 

#pragma once

#include "CoreMinimal.h"

class GreyscalegorillaProtocol
{
public:
    static TArray<uint8> EncodeMessage(const FString& Message);
    static TArray<FString> DecodeBuffer(const TArray<uint8>& Buffer);

private:
    static const TArray<uint8> StartDelimiter;
    static const TArray<uint8> EndDelimiter;
    static const int32 LengthSize;
    static const int32 CRCSize;

    static uint16 CRC16(const TArray<uint8>& Data);
    static TArray<uint8> ConvertUInt16ToUInt8(uint16 Value);
    static FString BytesToUTF8String(TArray<uint8>& Bytes);
};